import pandas as pd  
import pickle
from decision_company import read_csv_file, access_dataframe_loc, access_dataframe_loc, logical_and

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Create groups based on young_customer and good_credit_history  
group1 = access_dataframe_loc(credit_customers, logical_and(credit_customers['young_customer'], good_credit_history), 'credit_amount')  
group2 = access_dataframe_loc(credit_customers, logical_and(~credit_customers['young_customer'], good_credit_history), 'credit_amount')  
group3 = access_dataframe_loc(credit_customers, logical_and(credit_customers['young_customer'], ~good_credit_history), 'credit_amount')  
group4 = access_dataframe_loc(credit_customers, logical_and(~credit_customers['young_customer'], ~good_credit_history), 'credit_amount')  
  
 
pickle.dump(group1,open("./ref_result/group1.pkl","wb"))
pickle.dump(group2,open("./ref_result/group2.pkl","wb"))
pickle.dump(group3,open("./ref_result/group3.pkl","wb"))
pickle.dump(group4,open("./ref_result/group4.pkl","wb"))